<?php

namespace App\Helpers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class Helper
{
    /** FORMAT TANGGAL INDONESIA */
    public static function tgl_indo($tanggal)
    { //@juna
        // Handle empty or invalid dates
        if (empty($tanggal) || $tanggal === '0000-00-00' || $tanggal === null) {
            return '';
        }
        
        $bulan = array(
            1 => 'Januari',
            'Februari',
            'Maret',
            'April',
            'Mei',
            'Juni',
            'Juli',
            'Agustus',
            'September',
            'Oktober',
            'November',
            'Desember'
        );
        
        $split = explode('-', $tanggal);
        
        // Ensure we have all parts of the date to prevent array key errors
        if (count($split) < 3) {
            return $tanggal; // Return original if can't parse
        }
        
        $day = isset($split[2]) ? $split[2] : '00';
        $month = isset($split[1]) ? (int)$split[1] : 1;
        $year = isset($split[0]) ? $split[0] : '0000';
        
        // Ensure month is valid to prevent array key error
        if ($month < 1 || $month > 12) {
            $month = 1;
        }
        
        return $day . ' ' . $bulan[$month] . ' ' . $year;
    }
    /** remove tag html */
    public static function string_rmv_html($param)
    {
        // Handle null or empty parameters to prevent errors
        if (empty($param) || is_null($param)) {
            return '';
        }
        
        $string = str_replace(['(', ')'], '', str_replace(['<p>', '</p>'], '', $param));
        return $string;
    }

    public static function checkAuth($id_users) {
        $data = DB::connection()->select(
            "SELECT
            users.id AS id_users,
            users.name,
            users.email,
            users_role.roles_name
        FROM users
            join users_role on users.role = users_role.id
        WHERE users.id = $id_users");
        return $data;
    }

    public static function getVisitor() {
        $datenow = date('Y-m-d');
        $year = date('Y');
        $bln = date('m');
        $data = DB::connection()->select(
            "SELECT 
            sum(if(date = '$datenow',hits,0)) as daily,
            sum(if(YEARWEEK(`date`, 1) = YEARWEEK(CURDATE(), 1),hits,0)) as weekly,
            sum(if(year(date) = '$year' and month(date) = '$bln', hits, 0 )) as mounty,
            sum(if(year(date) = '$year', hits, 0 )) as yearly
            FROM visitor ");
        return $data;
    }

    public static function getSurvei() {
        try {
            $data = DB::connection()->select(
                "SELECT *
                FROM survei_kepuasan ");
            return $data;
        } catch (\Exception $e) {
            // Return default values if table doesn't exist
            return [(object)[
                'sangat_puas' => 0,
                'puas' => 0,
                'kurang_puas' => 0,
                'tidak_puas' => 0
            ]];
        }
    }
}
