<?php

namespace App\Helpers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Request;
use GoogleTranslate;

class Smt {

    public static function translate($word, $getLocal)
    {
        return app()->getLocale() != "id" ? GoogleTranslate::trans($word, $getLocal) : $word;
    }

    //generator helper
    public static function set_input_crud($val_type,$val_name,$value=null,$relation=null)
    {
        //check kalo upload
        if($val_type == "upload"){
            $ar =  '<input type="file" class="form-control dropify" name="'.$val_name.'" id="'.$val_name.'">';
            return $ar;
        }

        if(isset($relation[$val_name])){
            $get_relation = $relation[$val_name];
            $data_relation = DB::table($get_relation[0])->whereNull('deleted_at')->get();//get tabel
          
            
            $ar =   '<select name="'.$val_name.'" id="'.$val_name.'" class="form-control selected2">
                        <option value="">Pilih</option>';
                        foreach ($data_relation as $item) {
                            $id_relation = $get_relation[1];
                            $val_relation = $get_relation[2];

                            if ($item->$id_relation==$value) {
                                $is_selected = "selected";
                            } else {
                                $is_selected = null;
                            }
                            

                            $ar .= '<option value="'.$item->$id_relation.'" '.$is_selected.'>'.$item->$val_relation.'</option>';
                        }
            $ar .=  '</select>';
        }
        if ($val_type=="\BigInt"){
            $ar =  '<input type="number" class="form-control" name="'.$val_name.'" value="'.$value.'" id="'.$val_name.'" required>';
        }
        if($val_type=="\String"){
            $ar = '<input type="text" class="form-control" name="'.$val_name.'" value="'.$value.'" id="'.$val_name.'" required>';
        }
        if($val_type=="\Text"){
            $ar = '<textarea class="form-control" name="'.$val_name.'" id="'.$val_name.'" cols="30" rows="10" required>'.$value.'</textarea>';
        }
        if($val_type=="\Date"){
            $ar = '<input type="date" class="form-control" name="'.$val_name.'" id="'.$val_name.'" value="'.$value.'" required>';
        }
        if($val_type=="\Boolean"){
            //$cekhed = null;
            if ($value=="1"){ 
                $cekhed = "checked";
            }else{ 
                $cekhed = null;
            }
            
            
            $ar = '<div class="form-check">
                        <label class="form-check-label">
                            <input type="checkbox" name="'.$val_name.'" id="'.$val_name.'" value="1" class="form-check-input" '.$cekhed.'>
                            Aktif
                            <i class="input-helper"></i>
                        </label>
                    </div>';
        }
        if(empty($val_type)){
            $ar = "belum terdefinisi ".$val_type;
        }
        
        return $ar;
        
    }
    //end generator helper

   
    public static function create_link($url) {
        $url = strip_tags($url);
        $url = str_replace(" ","-",$url);
        $url = str_replace("!","",$url);
        $url = str_replace("@","",$url);
        $url = str_replace("#","",$url);
        $url = str_replace("$","",$url);
        $url = str_replace("%","",$url);
        $url = str_replace("^","",$url);
        $url = str_replace("&","",$url);
        $url = str_replace("*","",$url);
        $url = str_replace("(","",$url);
        $url = str_replace(")","",$url);
        $url = str_replace("_","",$url);
        $url = str_replace("+","",$url);
        $url = str_replace("=","",$url);
        $url = str_replace("{","",$url);
        $url = str_replace("}","",$url);
        $url = str_replace("[","",$url);
        $url = str_replace("]","",$url);
        $url = str_replace("|","",$url);
        $url = str_replace('"',"",$url);
        $url = str_replace(";","",$url);
        $url = str_replace(">","",$url);
        $url = str_replace('<',"",$url);
        $url = str_replace("?","",$url);
        $url = str_replace("/","",$url);
        $url = str_replace('~',"",$url);
        $url = str_replace("`","",$url);
        $url = str_replace(".","",$url);
        $url = str_replace(",","",$url);
        $url = str_replace(":","",$url);
        $url = str_replace("'","",$url);
        $url = addslashes($url);
        $url = strtolower($url);

        return $url;
    }

    //function fbulan
    public static function fbulan ($bulan) {
		if ($bulan=="01") { $bln="Januari"; } else if ($bulan=="02") { $bln="Februari"; } 
		else if ($bulan=="03") { $bln="Maret"; } else if ($bulan=="04") { $bln="April"; } 
		else if ($bulan=="05") { $bln="Mei"; } else if ($bulan=="06") { $bln="Juni"; } 
		else if ($bulan=="07") { $bln="Juli"; } else if ($bulan=="08") { $bln="Agustus"; } 
		else if ($bulan=="09") { $bln="September"; } else if ($bulan=="10") { $bln="Oktober"; } 
		else if ($bulan=="11") { $bln="November"; } else if ($bulan=="12") { $bln="Desember"; }
		else { $bln = ""; }
		return $bln;
    }

   
    public static function rupiah_format($nominal)
    {

        return number_format($nominal, 0, 0, ".");
    }
    //function fdate
    public static function fdate ($value,$format) {
        if($value != ""){
            list($thn,$bln,$tgl) = explode("-",$value);
    
            switch ($format) {
                case "DDMMYYYY" : 
                    $return = $tgl." ".Smt::fbulan($bln)." ".$thn;
                break;
                //new case
                case "DDMM" : 
                    $return = $tgl." ".Smt::fbulan($bln);
                break;
                case "DD" : 
                    $return = $tgl;
                break;
                case "MM" : 
                    $return = $bln;
                break;
                case "YYYYY" : 
                    $return = $thn;
                break;
                case "mm" : 
                    $return = Smt::fbulan($bln);
                break;
                case "HHDDMMYYYY" :
                    $jam = explode(" ",$value)[1];
                    $tgl = explode(" ",$tgl)[0];
                    list($H,$M,$S) = explode(":",$jam); 
                    $return = $tgl." ".Smt::fbulan($bln)." ".$thn." | ".$H.":".$M;
                break;

                case "HDDMMYYYY" :
                    $jam = explode(" ",$value)[1];
                    $tgl = explode(" ",$tgl)[0];
                    list($H,$M,$S) = explode(":",$jam); 
                    $return = $tgl." ".Smt::fbulan($bln)." ".$thn;
                break;

                case "SesiHHDDMMYYYY" :
                    $jam = explode(" ",$value)[1];
                    $tgl = explode(" ",$tgl)[0];
                    list($H,$M,$S) = explode(":",$jam); 
                    $return = $tgl." ".Smt::fbulan($bln)." ".$thn;
                break;
            
            }
        } else {
            $return = "";
        }
        return $return;
    }

    public static function get_num_phone($nohp) {
        // kadang ada penulisan no hp 0811 239 345
        $nohp = str_replace(" ","",$nohp);
        // kadang ada penulisan no hp (0274) 778787
        $nohp = str_replace("(","",$nohp);
        // kadang ada penulisan no hp (0274) 778787
        $nohp = str_replace(")","",$nohp);
        // kadang ada penulisan no hp 0811.239.345
        $nohp = str_replace(".","",$nohp);
    
        // cek apakah no hp mengandung karakter + dan 0-9
        if(!preg_match('/[^+0-9]/',trim($nohp))){
            // cek apakah no hp karakter 1-3 adalah +62
            if(substr(trim($nohp), 0, 3)=='+62'){
                $hp = trim($nohp);
            }
            // cek apakah no hp karakter 1 adalah 0
            elseif(substr(trim($nohp), 0, 1)=='0'){
                $hp = '+62'.substr(trim($nohp), 1);
            }
        }
       return $hp;
    }

    public static function get_img($news_content = NULL){


        $dom=new \DOMDocument();
       
       
       
       
       
        if ($news_content == "") {
       
       
            return NULL;
       
       
        }
       
       
       
       
       
        libxml_use_internal_errors(true);
       
       
        $dom->loadHTML($news_content);
       
       
        libxml_use_internal_errors(false);
       
       
        $img_nodes=$dom->getElementsByTagName('img');
       
       
       
       
       
        $img_link = NULL;
       
       
        foreach($img_nodes as $link) {
       
       
            $img_link=$link->getAttribute('src');
            break;
       
        }
       
       
       
       
       
         return $img_link;
       
       
    }

    public static function img_empty($asset,$value)
    {
        if(empty($value)){
            $img = asset('assets/public/images/intro/blank.png');
        }else{
            $img = asset($asset.$value);
        }
        return $img;
    }
    //get title
    public static function name_url($url_segment)
    {
        $get_name_control = DB::table('ms_menus')->where('link','=',$url_segment)->first();
        $url = $get_name_control->name;
        return $url;
    }
       
    //get link controller
    public static function name_link($url_segment)
    {
        if($url_segment == NULL)
        {
            $url_segment = '/';
        }
        $get_name_control = DB::table('ms_menus')->where('link','=',$url_segment)->first();
        $url = $get_name_control->link;
        return $url;
    }

    public static function name_controller($value = null){
        $get_name = DB::table('ms_menus')->where('link','=',Request::segment(1))->where('deleted_at',NULL)->first();
        $name = $get_name->type;
        return $name;
    }

    public static function get_type($value = null){
        if(Request::segment(1) == NULL)
        {
            return '1';
        }
        $get_name = DB::table('ms_menus')->where('link','=',Request::segment(1))->where('deleted_at',NULL)->first();
        $name = $get_name->type;
        return $name;
    }

    public static function get_menuid($type = null){
        if($type == NULL)
        {
            $get_name = DB::table('ms_menus')->where('link','=',Request::segment(1))->where('deleted_at',NULL)->first();
        }else{
            $get_name = DB::table('ms_menus')->where('type','=',$type)->where('deleted_at',NULL)->first();
        }
        $name = $get_name->id;
        return $name;
    }

    public static function get_linkmenu($type = null)
    {
        if($type == NULL)
        {
            $get_name_control = DB::table('ms_menus')->where('link','=',Request::segment(1))->first();
        }else{
            $get_name_control = DB::table('ms_menus')->where('type','=',$type)->first();
        }
        $url = $get_name_control->link;
        return $url;
    }

    public static function get_linkname()
    {
        $url_segment = Request::segment(1);
        if($url_segment == NULL)
        {
            $url_segment = '';
        }
        $get_name_control = DB::table('ms_menus')->where('link','=',$url_segment)->where('deleted_at',NULL)->first();
        $url = $get_name_control->name;
        return $url;
    }

    public static function get_adminmenu($value = null){
        $get_name = DB::table('ms_menuadm')->where('link','=',"/".$value)->where('deleted_at',NULL)->first();
        if($get_name == NULL)
        {
            return "";
        }
        return $get_name;
    }

    public static function getLayout($type,$module)
    {
        if($type == "1")
        {
            ?>
            Lorem, ipsum dolor sit amet consectetur adipisicing elit. Temporibus, commodi aut! Aperiam, alias? Cumque omnis quibusdam nostrum maiores ipsum, quasi officia inventore doloremque accusamus quis doloribus sit quos quae dolorem?
            <?php
        }
    }

    public static function GetLayoutModule($column,$modules)
    {
        return view('masterweb::module.admin.layoutmodule.columns',compact('column','modules'));
    }

    public static function GetLayoutModulePublic($column,$modules)
    {
        return view('masterweb::module.admin.layoutmodule.column_modules',compact('column','modules'));
    }

    public static function getModule($module)
    {
        $getModule = DB::table('ms_module')->where('id','=',$module)->first();
        ?>
        <div class="card rounded border mb-2">
            <div class="card-body p-3 moduleId" data-id="<?= $module ?>">
                <div class="media">
                <i class="fa fa-news icon-sm text-primary align-self-center mr-3"></i>
                <div class="media-body">
                    <h6 class="mb-1"><?= $getModule->name ?></h6>
                    <p class="mb-0 text-muted">
                        <?= $getModule->module ?>
                    </p>
                </div>                              
                </div> 
            </div>
        </div>
        <?php
    }

    public static function smt_reference ($kode,$value = null){

        switch ($kode) {
            case 'PUBLISH':
                $data = array(
                    '1' => 'Aktif',
                    '0' => 'Tidak Aktif'
                );
            break;

            case 'CONTENTREF':
                $data = array(
                    '1' => 'Full',
                    '0' => 'List'
                );
            break;
            
            case 'SEKS':
                $data = array(
                    'L' => 'Laki-laki',
                    'P' => 'Perempuan',
                    'l' => 'Laki-laki',
                    'p' => 'Perempuan'
                );
            break;
            
            case 'AGAMA':
                $data = array(
                    '1' => 'Islam',
                    '2' => 'Kristen Protestan',
                    '3' => 'Kristen Katolik',
                    '4' => 'Hindu',
                    '5' => 'Budha',
                    '6' => 'Konghuchu'
                );
            break;

            case 'SERAGAM':
                $data = array(
                    '1' => 'Seragam Osis',
                    '2' => 'Seragam Pramuka',
                    '3' => 'Seragam Olahraga',
                    '4' => 'Seragam Jurusan',
                );
            break;
            
            case 'JENJANG':
                $data = array(
                    'SD' => 'SD/MI Sederajat',
                    'SMP' => 'SMP/MTS Sederajat',
                    'SMA' => 'SMA/SMK/MK Sederajat',
                );
        }
    
        if($value == null){
            return $data;
        }else{
            return $data[$value];
        }
    }
    
    public static function isSelected($a,$b)
    {
        if($a == $b)
        {
            return "selected";
        }
    }

    public static function ischecked($a,$b)
    {
        if($a == $b)
        {
            return "checked";
        }
    }

    public static function Info_umum($value)
    {
        # code...
        if($value == 1)
        {
            return "Search Engine";
        } 
        elseif($value == 2)
        {
            return "Mailing Partner";
        }
        elseif($value == 3)
        {
            return "News Letter";
        }
        elseif($value == 4)
        {
            return "Facebook";
        }
        else
        {
            return "Twitter";
        }
    }

    public static function asal_sekolah()
    {
        $ar = array(
            'SMP N 1 MARGOYOSO',
            'SMP N 2 MARGOYOSO',
            'SMP N 1 GUNUNGWUNGKAL',
            'SMP N 2 GUNUNGWUNGKAL',
            'SMP N 1 TRANGKIL',
            'SMP N 2 TRANGKIL',
            'SMP N 1 TAYU',
            'SMP N 2 TAYU',
            'SMP N 1 CLUWAK',
            'SMP N 1 DUKUHSETI',
            'SMP N SATU ATAP TANJUNGREJO',
            'MTS N 2 PATI',
            'MTS RAUDLATUT THOLIBIN',
            'MTS MIFTAHUL HUDA',
            'MTS DARUN NAJAH',
            'MTS MIFTAHUL FALAH',
            'MTS PI AL HUDA',
            'MTS AL HIKMAH',
            'MTS IANATUT THOLIBIN',
            'MTS BAITUS SALAM'
        );
        return $ar;
    }

    public static function template_email($url,$nama_member,$status_member,$opt){
        $html = '

        <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional //EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><!--[if IE]><html xmlns="http://www.w3.org/1999/xhtml" class="ie"><![endif]--><!--[if !IE]><!--><html style="margin: 0;padding: 0;" xmlns="http://www.w3.org/1999/xhtml"><!--<![endif]--><head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <title></title>
            <!--[if !mso]><!--><meta http-equiv="X-UA-Compatible" content="IE=edge" /><!--<![endif]-->
            <meta name="viewport" content="width=device-width" /><style type="text/css">
            @media only screen and (min-width: 620px){.wrapper{min-width:600px !important}.wrapper h1{}.wrapper h1{font-size:26px !important;line-height:34px !important}.wrapper h2{}.wrapper h2{font-size:20px !important;line-height:28px !important}.wrapper h3{}.column{}.wrapper .size-8{font-size:8px !important;line-height:14px !important}.wrapper .size-9{font-size:9px !important;line-height:16px !important}.wrapper .size-10{font-size:10px !important;line-height:18px !important}.wrapper .size-11{font-size:11px !important;line-height:19px !important}.wrapper .size-12{font-size:12px !important;line-height:19px !important}.wrapper .size-13{font-size:13px !important;line-height:21px !important}.wrapper .size-14{font-size:14px !important;line-height:21px !important}.wrapper .size-15{font-size:15px !important;line-height:23px !important}.wrapper .size-16{font-size:16px !important;line-height:24px 
            !important}.wrapper .size-17{font-size:17px !important;line-height:26px !important}.wrapper .size-18{font-size:18px !important;line-height:26px !important}.wrapper .size-20{font-size:20px !important;line-height:28px !important}.wrapper .size-22{font-size:22px !important;line-height:31px !important}.wrapper .size-24{font-size:24px !important;line-height:32px !important}.wrapper .size-26{font-size:26px !important;line-height:34px !important}.wrapper .size-28{font-size:28px !important;line-height:36px !important}.wrapper .size-30{font-size:30px !important;line-height:38px !important}.wrapper .size-32{font-size:32px !important;line-height:40px !important}.wrapper .size-34{font-size:34px !important;line-height:43px !important}.wrapper .size-36{font-size:36px !important;line-height:43px !important}.wrapper .size-40{font-size:40px !important;line-height:47px !important}.wrapper 
            .size-44{font-size:44px !important;line-height:50px !important}.wrapper .size-48{font-size:48px !important;line-height:54px !important}.wrapper .size-56{font-size:56px !important;line-height:60px !important}.wrapper .size-64{font-size:64px !important;line-height:63px !important}}
            </style>
                <meta name="x-apple-disable-message-reformatting" />
                <style type="text/css">
            body {
            margin: 0;
            padding: 0;
            }
            table {
            border-collapse: collapse;
            table-layout: fixed;
            }
            * {
            line-height: inherit;
            }
            [x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            }
            .wrapper .footer__share-button a:hover,
            .wrapper .footer__share-button a:focus {
            color: #ffffff !important;
            }
            .btn a:hover,
            .btn a:focus,
            .footer__share-button a:hover,
            .footer__share-button a:focus,
            .email-footer__links a:hover,
            .email-footer__links a:focus {
            opacity: 0.8;
            }
            .preheader,
            .header,
            .layout,
            .column {
            transition: width 0.25s ease-in-out, max-width 0.25s ease-in-out;
            }
            .preheader td {
            padding-bottom: 8px;
            }
            .layout,
            div.header {
            max-width: 400px !important;
            -fallback-width: 95% !important;
            width: calc(100% - 20px) !important;
            }
            div.preheader {
            max-width: 360px !important;
            -fallback-width: 90% !important;
            width: calc(100% - 60px) !important;
            }
            .snippet,
            .webversion {
            Float: none !important;
            }
            .stack .column {
            max-width: 400px !important;
            width: 100% !important;
            }
            .fixed-width.has-border {
            max-width: 402px !important;
            }
            .fixed-width.has-border .layout__inner {
            box-sizing: border-box;
            }
            .snippet,
            .webversion {
            width: 50% !important;
            }
            .ie .btn {
            width: 100%;
            }
            .ie .stack .column,
            .ie .stack .gutter {
            display: table-cell;
            float: none !important;
            }
            .ie div.preheader,
            .ie .email-footer {
            max-width: 560px !important;
            width: 560px !important;
            }
            .ie .snippet,
            .ie .webversion {
            width: 280px !important;
            }
            .ie div.header,
            .ie .layout {
            max-width: 600px !important;
            width: 600px !important;
            }
            .ie .two-col .column {
            max-width: 300px !important;
            width: 300px !important;
            }
            .ie .three-col .column,
            .ie .narrow {
            max-width: 200px !important;
            width: 200px !important;
            }
            .ie .wide {
            width: 400px !important;
            }
            .ie .stack.fixed-width.has-border,
            .ie .stack.has-gutter.has-border {
            max-width: 602px !important;
            width: 602px !important;
            }
            .ie .stack.two-col.has-gutter .column {
            max-width: 290px !important;
            width: 290px !important;
            }
            .ie .stack.three-col.has-gutter .column,
            .ie .stack.has-gutter .narrow {
            max-width: 188px !important;
            width: 188px !important;
            }
            .ie .stack.has-gutter .wide {
            max-width: 394px !important;
            width: 394px !important;
            }
            .ie .stack.two-col.has-gutter.has-border .column {
            max-width: 292px !important;
            width: 292px !important;
            }
            .ie .stack.three-col.has-gutter.has-border .column,
            .ie .stack.has-gutter.has-border .narrow {
            max-width: 190px !important;
            width: 190px !important;
            }
            .ie .stack.has-gutter.has-border .wide {
            max-width: 396px !important;
            width: 396px !important;
            }
            .ie .fixed-width .layout__inner {
            border-left: 0 none white !important;
            border-right: 0 none white !important;
            }
            .ie .layout__edges {
            display: none;
            }
            .mso .layout__edges {
            font-size: 0;
            }
            .layout-fixed-width,
            .mso .layout-full-width {
            background-color: #ffffff;
            }
            @media only screen and (min-width: 620px) {
            .column,
            .gutter {
                display: table-cell;
                Float: none !important;
                vertical-align: top;
            }
            div.preheader,
            .email-footer {
                max-width: 560px !important;
                width: 560px !important;
            }
            .snippet,
            .webversion {
                width: 280px !important;
            }
            div.header,
            .layout,
            .one-col .column {
                max-width: 600px !important;
                width: 600px !important;
            }
            .fixed-width.has-border,
            .fixed-width.x_has-border,
            .has-gutter.has-border,
            .has-gutter.x_has-border {
                max-width: 602px !important;
                width: 602px !important;
            }
            .two-col .column {
                max-width: 300px !important;
                width: 300px !important;
            }
            .three-col .column,
            .column.narrow,
            .column.x_narrow {
                max-width: 200px !important;
                width: 200px !important;
            }
            .column.wide,
            .column.x_wide {
                width: 400px !important;
            }
            .two-col.has-gutter .column,
            .two-col.x_has-gutter .column {
                max-width: 290px !important;
                width: 290px !important;
            }
            .three-col.has-gutter .column,
            .three-col.x_has-gutter .column,
            .has-gutter .narrow {
                max-width: 188px !important;
                width: 188px !important;
            }
            .has-gutter .wide {
                max-width: 394px !important;
                width: 394px !important;
            }
            .two-col.has-gutter.has-border .column,
            .two-col.x_has-gutter.x_has-border .column {
                max-width: 292px !important;
                width: 292px !important;
            }
            .three-col.has-gutter.has-border .column,
            .three-col.x_has-gutter.x_has-border .column,
            .has-gutter.has-border .narrow,
            .has-gutter.x_has-border .narrow {
                max-width: 190px !important;
                width: 190px !important;
            }
            .has-gutter.has-border .wide,
            .has-gutter.x_has-border .wide {
                max-width: 396px !important;
                width: 396px !important;
            }
            }
            @supports (display: flex) {
            @media only screen and (min-width: 620px) {
                .fixed-width.has-border .layout__inner {
                display: flex !important;
                }
            }
            }
            @media only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx) {
            .fblike {
                background-image: url(https://i7.createsend1.com/static/eb/master/13-the-blueprint-3/images/fblike@2x.png) !important;
            }
            .tweet {
                background-image: url(https://i8.createsend1.com/static/eb/master/13-the-blueprint-3/images/tweet@2x.png) !important;
            }
            .linkedinshare {
                background-image: url(https://i9.createsend1.com/static/eb/master/13-the-blueprint-3/images/lishare@2x.png) !important;
            }
            .forwardtoafriend {
                background-image: url(https://i10.createsend1.com/static/eb/master/13-the-blueprint-3/images/forward@2x.png) !important;
            }
            }
            @media (max-width: 321px) {
            .fixed-width.has-border .layout__inner {
                border-width: 1px 0 !important;
            }
            .layout,
            .stack .column {
                min-width: 320px !important;
                width: 320px !important;
            }
            .border {
                display: none;
            }
            .has-gutter .border {
                display: table-cell;
            }
            }
            .mso div {
            border: 0 none white !important;
            }
            .mso .w560 .divider {
            Margin-left: 260px !important;
            Margin-right: 260px !important;
            }
            .mso .w360 .divider {
            Margin-left: 160px !important;
            Margin-right: 160px !important;
            }
            .mso .w260 .divider {
            Margin-left: 110px !important;
            Margin-right: 110px !important;
            }
            .mso .w160 .divider {
            Margin-left: 60px !important;
            Margin-right: 60px !important;
            }
            .mso .w354 .divider {
            Margin-left: 157px !important;
            Margin-right: 157px !important;
            }
            .mso .w250 .divider {
            Margin-left: 105px !important;
            Margin-right: 105px !important;
            }
            .mso .w148 .divider {
            Margin-left: 54px !important;
            Margin-right: 54px !important;
            }
            .mso .size-8,
            .ie .size-8 {
            font-size: 8px !important;
            line-height: 14px !important;
            }
            .mso .size-9,
            .ie .size-9 {
            font-size: 9px !important;
            line-height: 16px !important;
            }
            .mso .size-10,
            .ie .size-10 {
            font-size: 10px !important;
            line-height: 18px !important;
            }
            .mso .size-11,
            .ie .size-11 {
            font-size: 11px !important;
            line-height: 19px !important;
            }
            .mso .size-12,
            .ie .size-12 {
            font-size: 12px !important;
            line-height: 19px !important;
            }
            .mso .size-13,
            .ie .size-13 {
            font-size: 13px !important;
            line-height: 21px !important;
            }
            .mso .size-14,
            .ie .size-14 {
            font-size: 14px !important;
            line-height: 21px !important;
            }
            .mso .size-15,
            .ie .size-15 {
            font-size: 15px !important;
            line-height: 23px !important;
            }
            .mso .size-16,
            .ie .size-16 {
            font-size: 16px !important;
            line-height: 24px !important;
            }
            .mso .size-17,
            .ie .size-17 {
            font-size: 17px !important;
            line-height: 26px !important;
            }
            .mso .size-18,
            .ie .size-18 {
            font-size: 18px !important;
            line-height: 26px !important;
            }
            .mso .size-20,
            .ie .size-20 {
            font-size: 20px !important;
            line-height: 28px !important;
            }
            .mso .size-22,
            .ie .size-22 {
            font-size: 22px !important;
            line-height: 31px !important;
            }
            .mso .size-24,
            .ie .size-24 {
            font-size: 24px !important;
            line-height: 32px !important;
            }
            .mso .size-26,
            .ie .size-26 {
            font-size: 26px !important;
            line-height: 34px !important;
            }
            .mso .size-28,
            .ie .size-28 {
            font-size: 28px !important;
            line-height: 36px !important;
            }
            .mso .size-30,
            .ie .size-30 {
            font-size: 30px !important;
            line-height: 38px !important;
            }
            .mso .size-32,
            .ie .size-32 {
            font-size: 32px !important;
            line-height: 40px !important;
            }
            .mso .size-34,
            .ie .size-34 {
            font-size: 34px !important;
            line-height: 43px !important;
            }
            .mso .size-36,
            .ie .size-36 {
            font-size: 36px !important;
            line-height: 43px !important;
            }
            .mso .size-40,
            .ie .size-40 {
            font-size: 40px !important;
            line-height: 47px !important;
            }
            .mso .size-44,
            .ie .size-44 {
            font-size: 44px !important;
            line-height: 50px !important;
            }
            .mso .size-48,
            .ie .size-48 {
            font-size: 48px !important;
            line-height: 54px !important;
            }
            .mso .size-56,
            .ie .size-56 {
            font-size: 56px !important;
            line-height: 60px !important;
            }
            .mso .size-64,
            .ie .size-64 {
            font-size: 64px !important;
            line-height: 63px !important;
            }
            .btn {
                border-radius: 3px;
                box-shadow: 0 2px 3px rgba(0, 0, 0, 0.16);
                color: #fff;
                display: inline-block;
                text-decoration: none;
                -webkit-text-size-adjust: none;
            }
            .btn-red,
            .btn-error {
                background-color: #e3342f;
                border-top: 10px solid #e3342f;
                border-right: 18px solid #e3342f;
                border-bottom: 10px solid #e3342f;
                border-left: 18px solid #e3342f;
            }
            </style>
                
            <!--[if !mso]><!--><style type="text/css">
            @import url(https://fonts.googleapis.com/css?family=Roboto:400,700,400italic,700italic);
            </style><link href="https://fonts.googleapis.com/css?family=Roboto:400,700,400italic,700italic" rel="stylesheet" type="text/css" /><!--<![endif]--><style type="text/css">
            body{background-color:#fbfbfb}.logo a:hover,.logo a:focus{color:#1e2e3b !important}.mso .layout-has-border{border-top:1px solid #c8c8c8;border-bottom:1px solid #c8c8c8}.mso .layout-has-bottom-border{border-bottom:1px solid #c8c8c8}.mso .border,.ie .border{background-color:#c8c8c8}.mso h1,.ie h1{}.mso h1,.ie h1{font-size:26px !important;line-height:34px !important}.mso h2,.ie h2{}.mso h2,.ie h2{font-size:20px !important;line-height:28px !important}.mso h3,.ie h3{}.mso .layout__inner,.ie .layout__inner{}.mso .footer__share-button p{}.mso .footer__share-button p{font-family:Georgia,serif}
            </style><meta name="robots" content="noindex,nofollow" />
            <meta property="og:title" content="My First Campaign" />
            </head>
            <!--[if mso]>
            <body class="mso">
            <![endif]-->
            <!--[if !mso]><!-->
            <body class="full-padding" style="margin: 0;padding: 0;-webkit-text-size-adjust: 100%;">
            <!--<![endif]-->
                <table class="wrapper" style="border-collapse: collapse;table-layout: fixed;min-width: 320px;width: 100%;background-color: #fbfbfb;" cellpadding="0" cellspacing="0" role="presentation"><tbody><tr><td>
                <div role="banner">
                    <div class="preheader" style="Margin: 0 auto;max-width: 560px;min-width: 280px; width: 280px;width: calc(28000% - 167440px);">
                    <div style="border-collapse: collapse;display: table;width: 100%;">
                    <!--[if (mso)|(IE)]><table align="center" class="preheader" cellpadding="0" cellspacing="0" role="presentation"><tr><td style="width: 280px" valign="top"><![endif]-->
                        <div class="snippet" style="display: table-cell;Float: left;font-size: 12px;line-height: 19px;max-width: 280px;min-width: 140px; width: 140px;width: calc(14000% - 78120px);padding: 10px 0 5px 0;color: #999;font-family: Georgia,serif;">
                        
                        </div>
                    <!--[if (mso)|(IE)]></td><td style="width: 280px" valign="top"><![endif]-->
                        <div class="webversion" style="display: table-cell;Float: left;font-size: 12px;line-height: 19px;max-width: 280px;min-width: 139px; width: 139px;width: calc(14100% - 78680px);padding: 10px 0 5px 0;text-align: right;color: #999;font-family: Georgia,serif;">
                        </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    </div>
                    </div>
                    <div class="header" style="Margin: 0 auto;max-width: 600px;min-width: 320px; width: 320px;width: calc(28000% - 167400px);" id="emb-email-header-container">
                    <!--[if (mso)|(IE)]><table align="center" class="header" cellpadding="0" cellspacing="0" role="presentation"><tr><td style="width: 600px"><![endif]-->
                    <div class="logo emb-logo-margin-box" style="font-size: 26px;line-height: 32px;Margin-top: 6px;Margin-bottom: 20px;color: #41637e;font-family: Avenir,sans-serif;Margin-left: 20px;Margin-right: 20px;" align="center">
                    <div class="logo-center" align="center" id="emb-email-header"><img style="display: block;height: auto;width: 100%;border: 0;max-width: 254px;" src="" alt="" width="254" /></div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    </div>
                </div>
                <div>
                <div class="layout one-col fixed-width stack" style="Margin: 0 auto;max-width: 600px;min-width: 320px; width: 320px;width: calc(28000% - 167400px);overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;">
                    <div class="layout__inner" style="border-collapse: collapse;display: table;width: 100%;background-color: #ffffff;">
                    <!--[if (mso)|(IE)]><table align="center" cellpadding="0" cellspacing="0" role="presentation"><tr class="layout-fixed-width" style="background-color: #ffffff;"><td style="width: 600px" class="w560"><![endif]-->
                    <div class="column" style="text-align: left;color: #565656;font-size: 14px;line-height: 21px;font-family: Georgia,serif;">
                    
                        <div style="Margin-left: 20px;Margin-right: 20px;Margin-top: 24px;Margin-bottom: 24px;">
                <div style="mso-line-height-rule: exactly;mso-text-raise: 11px;vertical-align: middle;">
                    <h1 class="size-30" style="Margin-top: 0;Margin-bottom: 0;font-style: normal;font-weight: normal;color: #565656;font-size: 26px;line-height: 34px;font-family: Avenir,sans-serif;" lang="x-size-30">Hai '.$nama_member.' !</h1>
                    <p class="size-20" style="Margin-top: 20px;Margin-bottom: 0;font-family: roboto,tahoma,sans-serif;font-size: 17px;line-height: 26px;" lang="x-size-20"><span class="font-roboto">Terimakasih telah mendaftarkan diri di '.$opt->title.'.</span></p>
                    <p class="size-20" style="Margin-top: 20px;Margin-bottom: 0;font-family: roboto,tahoma,sans-serif;font-size: 17px;line-height: 26px;" lang="x-size-20"><span class="font-roboto">Silahkan Klik tombol dibawah ini untuk memverifikasi akun Anda.</span></p>
                
                    <a href="'.$url.'" style="Margin-top: 20px;Margin-bottom: 0;font-family: roboto,tahoma,sans-serif;font-size: 17px;line-height: 26px;color:#000;  border-radius: 3px;
                    box-shadow: 0 2px 3px rgba(0, 0, 0, 0.16);color: #fff;display: inline-block;text-decoration: none;-webkit-text-size-adjust: none;background-color: #e3342f;border-top: 10px solid #e3342f;border-right: 18px solid #e3342f;border-bottom: 10px solid #e3342f;border-left: 18px solid #e3342f;" target="_blank"><span class="font-roboto">  verifikasi </span></a>
                    
                    <p class="size-20" style="Margin-top: 20px;Margin-bottom: 0;font-family: roboto,tahoma,sans-serif;font-size: 17px;line-height: 26px;" lang="x-size-20"><span class="font-roboto">Hormat kami,</span><br><br><span class="font-roboto">Tim '.$opt->title.'.</span></p>
                </div>
                </div>
                    
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    </div>
                </div>
            
                <div style="mso-line-height-rule: exactly;line-height: 20px;font-size: 20px;">&nbsp;</div>
            
                
                <div role="contentinfo">
                    <div class="layout email-footer stack" style="Margin: 0 auto;max-width: 600px;min-width: 320px; width: 320px;width: calc(28000% - 167400px);overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;">
                    <div class="layout__inner" style="border-collapse: collapse;display: table;width: 100%;">
                    <!--[if (mso)|(IE)]><table align="center" cellpadding="0" cellspacing="0" role="presentation"><tr class="layout-email-footer"><td style="width: 400px;" valign="top" class="w360"><![endif]-->
                        <div class="column wide" style="text-align: left;font-size: 12px;line-height: 19px;color: #999;font-family: Georgia,serif;Float: left;max-width: 400px;min-width: 320px; width: 320px;width: calc(8000% - 47600px);">
                        <div style="Margin-left: 20px;Margin-right: 20px;Margin-top: 10px;Margin-bottom: 10px;">
                            <table class="email-footer__links" style="border-collapse: collapse;table-layout: fixed;" role="presentation" emb-web-links><tbody><tr role="navigation">
                            
                            </tr></tbody></table>
                            <div style="font-size: 12px;line-height: 19px;Margin-top: 20px;font-family: roboto,tahoma,sans-serif;">
                            <div class="font-roboto">Copyright SIMKRAF &#169; 2020 All rights reserved.</div>
                            </div>
                            <div style="font-size: 12px;line-height: 19px;Margin-top: 18px;">
                            
                            </div>
                            <!--[if mso]>&nbsp;<![endif]-->
                        </div>
                        </div>
                    <!--[if (mso)|(IE)]></td><td style="width: 200px;" valign="top" class="w160"><![endif]-->
                        <div class="column narrow" style="text-align: left;font-size: 12px;line-height: 19px;color: #999;font-family: Georgia,serif;Float: left;max-width: 320px;min-width: 200px; width: 320px;width: calc(72200px - 12000%);">
                        <div style="Margin-left: 20px;Margin-right: 20px;Margin-top: 10px;Margin-bottom: 10px;">
                            
                        </div>
                        </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    </div>
                    </div>
                    <div class="layout one-col email-footer" style="Margin: 0 auto;max-width: 600px;min-width: 320px; width: 320px;width: calc(28000% - 167400px);overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;">
                    <div class="layout__inner" style="border-collapse: collapse;display: table;width: 100%;">
                    <!--[if (mso)|(IE)]><table align="center" cellpadding="0" cellspacing="0" role="presentation"><tr class="layout-email-footer"><td style="width: 600px;" class="w560"><![endif]-->
                        <div class="column" style="text-align: left;font-size: 12px;line-height: 19px;color: #999;font-family: Georgia,serif;">
                        <div style="Margin-left: 20px;Margin-right: 20px;Margin-top: 10px;Margin-bottom: 10px;">
                            <div style="font-size: 12px;line-height: 19px;">
                            
                            </div>
                        </div>
                        </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    </div>
                    </div>
                </div>
                <div style="line-height:40px;font-size:40px;">&nbsp;</div>
                </div></td></tr></tbody></table>
        
        </body></html>

        ';

        return $html;
    }
    
    public static function takeIt($module)
    {
        if (isset($module[0]) AND $module[0] == "html")
        {
            echo $module[1];
        }else{
            $getModule = DB::table('ms_module')->where('id','=',$module)->first();
            echo view('masterweb::'.$getModule->module);
        }
    }
}
