<?php

namespace App\Http\Controllers;

use App\Models\Glosarium;
use Illuminate\Http\Request;

class GlosariumController extends Controller
{
    public function index(Request $request)
    {
        $query = $request->input('query');
        
        // Get total count untuk semua istilah (tidak berubah saat search)
        $totalIstilah = Glosarium::count();
        
        if ($query) {
            // Search dengan scope untuk relevansi yang lebih baik
            $kamus = Glosarium::search($query)
                        ->orderByRelevance($query)
                        ->paginate(15)
                        ->appends(['query' => $query]);
        } else {
            $kamus = Glosarium::orderBy('judul', 'asc')->paginate(15);
        }
        
        return view('page.glosarium.index', compact('kamus', 'query', 'totalIstilah'));
    }

    public function cari(Request $request)
    {
        $query = $request->input('query');
        
        // Get total count untuk semua istilah (tidak berubah saat search)
        $totalIstilah = Glosarium::count();

        if ($query) {
            $kamus = Glosarium::search($query)
                        ->orderByRelevance($query)
                        ->paginate(15)
                        ->appends(['query' => $query]);
        } else {
            $kamus = Glosarium::orderBy('judul', 'asc')->paginate(15);
        }

        return view('page.glosarium.index', compact('kamus', 'query', 'totalIstilah'));
    }

    /**
     * API untuk live search glosarium
     */
    public function apiSearch(Request $request)
    {
        $query = $request->input('query', '');
        
        // Get total count untuk semua istilah (tidak berubah saat search)
        $totalIstilah = Glosarium::count();
        
        if (empty($query)) {
            $kamus = Glosarium::orderBy('judul', 'asc')->paginate(15);
        } else {
            $kamus = Glosarium::search($query)
                        ->orderByRelevance($query)
                        ->paginate(15);
        }

        return response()->json([
            'data' => $kamus->items(),
            'total' => $kamus->total(), // Total hasil pencarian
            'total_istilah' => $totalIstilah, // Total semua istilah dalam database
            'current_page' => $kamus->currentPage(),
            'last_page' => $kamus->lastPage(),
            'per_page' => $kamus->perPage(),
            'from' => $kamus->firstItem(),
            'to' => $kamus->lastItem(),
            'query' => $query
        ]);
    }
}
