<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Update existing records to set created_by_role based on pengarang field
        
        // Update records where pengarang contains specific OPD patterns
        $opdPatterns = [
            'Badan Pengelola Keuangan dan Aset Daerah Provinsi Jawa Tengah' => 2, // user_id for BPKAD
            'Dinas Pendidikan dan Kebudayaan Provinsi Jawa Tengah' => 3, // user_id for Disdikbud
        ];
        
        foreach ($opdPatterns as $pengarang => $userId) {
            DB::table('inventarisasi_hukum')
                ->where('pengarang', $pengarang)
                ->whereNull('created_by_role')
                ->update([
                    'created_by_role' => 'opd',
                    'created_by_user_id' => $userId,
                    'updated_at' => now()
                ]);
        }
        
        // Update other records (like "Biro Hukum") to admin role
        DB::table('inventarisasi_hukum')
            ->where('pengarang', 'Biro Hukum')
            ->whereNull('created_by_role')
            ->update([
                'created_by_role' => 'admin',
                'created_by_user_id' => 1, // Super Admin user
                'updated_at' => now()
            ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Reset the created_by_role and created_by_user_id for records updated in up()
        DB::table('inventarisasi_hukum')
            ->whereIn('pengarang', [
                'Badan Pengelola Keuangan dan Aset Daerah Provinsi Jawa Tengah',
                'Dinas Pendidikan dan Kebudayaan Provinsi Jawa Tengah',
                'Biro Hukum'
            ])
            ->update([
                'created_by_role' => null,
                'created_by_user_id' => null,
                'updated_at' => now()
            ]);
    }
};
