@extends('app-admin')
@section('head')
    @include('admin.partial.head')
@endsection

@section('content')
<style>
/* Centering halaman duplikat - Pendekatan CSS Grid */
.main-content {
    display: grid;
    place-items: center;
    min-height: 100vh;
    width: 100vw;
    position: relative;
    left: 50%;
    transform: translateX(-57%);
    padding: 0;
    margin: 0;
}

.content-wrapper {
    display: grid;
    place-items: center;
    width: 100%;
    padding: 1rem 0;
}

/* Custom styles untuk halaman resolve duplicates */
.resolve-container {
    max-width: 1400px;
    width: 90%;
    padding: 1.5rem;
    margin: 0 auto;
    position: relative;
}

.warning-header {
    text-align: center;
    margin-bottom: 2rem;
    padding: 2rem 2.5rem;
    background: linear-gradient(135deg, #ffd93d 0%, #f39c12 100%);
    color: #2c3e50;
    border-radius: 15px;
    box-shadow: 0 10px 25px rgba(255, 217, 61, 0.3);
    width: 100%;
}

.warning-header h1 {
    font-size: 3.5rem;
    font-weight: 800;
    margin-bottom: 1rem;
    text-shadow: 1px 1px 2px rgba(255,255,255,0.3);
}

.warning-header p {
    font-size: 1.5rem;
    font-weight: 500;
    margin: 0;
    opacity: 0.95;
}

.card-title-large {
    font-size: 2.2rem !important;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 1.5rem;
    text-align: center;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    border-left: 5px solid #3498db;
}

.definition-title {
    font-size: 1.4rem;
    font-weight: 600;
    margin-bottom: 1rem;
    padding: 0.8rem;
    border-radius: 8px;
}

.definition-title.existing {
    background: #e3f2fd;
    color: #1976d2;
    border-left: 4px solid #2196f3;
}

.definition-title.new {
    background: #ffebee;
    color: #c62828;
    border-left: 4px solid #f44336;
}

.definition-content {
    font-size: 1.2rem;
    line-height: 1.6;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 10px;
    border: 2px solid #e9ecef;
    min-height: 120px;
}

.source-info {
    background: #fff3cd;
    border: 1px solid #ffeaa7;
    border-radius: 8px;
    padding: 0.8rem;
    margin-top: 1rem;
}

.source-info small {
    font-size: 1rem !important;
    color: #856404 !important;
}

.action-label {
    font-size: 1.3rem;
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 1rem;
}

.form-check-label {
    font-size: 1.2rem !important;
    font-weight: 500;
    margin-left: 0.8rem;
    cursor: pointer;
    padding: 0.8rem;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.form-check-label:hover {
    background: #f8f9fa;
}

.bulk-actions {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 25%, #7f8c8d 75%, #bdc3c7 100%);
    color: white;
    padding: 2.5rem 2rem;
    border-radius: 20px;
    margin-bottom: 2rem;
    text-align: center;
    width: 100%;
    box-shadow: 0 15px 35px rgba(44, 62, 80, 0.3);
    border: 3px solid rgba(255, 255, 255, 0.2);
}

.bulk-actions h5 {
    font-size: 2rem;
    margin-bottom: 2rem;
    font-weight: 700;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
}

.bulk-actions h5 i {
    font-size: 2.2rem;
    background: rgba(255, 255, 255, 0.2);
    padding: 0.8rem;
    border-radius: 50%;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.btn-bulk {
    font-size: 1.3rem;
    padding: 1.2rem 1.5rem;
    margin: 0.5rem;
    border-radius: 15px;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 2px solid transparent;
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-bulk:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 25px rgba(0,0,0,0.25);
    border-color: rgba(255, 255, 255, 0.5);
}

.btn-bulk i {
    font-size: 1.5rem;
    margin-right: 0.8rem;
    display: inline-block;
}

/* Enhanced button colors */
.btn-bulk.btn-light {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    color: #495057;
    border-color: #dee2e6;
}

.btn-bulk.btn-warning {
    background: linear-gradient(135deg, #ffc107 0%, #ff8f00 100%);
    color: white;
    border-color: #ffb300;
}

.btn-bulk.btn-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
    border-color: #17a2b8;
}

.btn-bulk.btn-outline-light {
    background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%);
    color: white;
    border: 2px solid rgba(255, 255, 255, 0.3);
}

/* Button content styling */
.btn-bulk div {
    font-weight: 700;
    margin: 0.3rem 0;
}

.btn-bulk small {
    display: block;
    font-weight: 400;
    margin-top: 0.3rem;
    font-style: italic;
}

/* Responsive button layout */
@media (max-width: 768px) {
    .bulk-actions .row {
        gap: 1rem;
    }
    
    .btn-bulk {
        margin-bottom: 1rem;
        padding: 1.5rem 1rem;
    }
    
    .bulk-actions h5 {
        font-size: 1.8rem;
    }
}

.submit-actions {
    text-align: center;
    padding: 2.5rem;
    background: #f8f9fa;
    border-radius: 15px;
    margin-top: 2rem;
    width: 100%;
}

.btn-submit {
    font-size: 1.3rem;
    padding: 1rem 3rem;
    border-radius: 25px;
    font-weight: 600;
    margin: 0.5rem;
}

.duplicate-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    margin-bottom: 2.5rem;
    overflow: hidden;
    padding: 2.5rem;
    background: white;
    width: 100%;
}

.form-check {
    margin-bottom: 1rem;
    padding: 0.5rem;
}

.form-check-input {
    width: 1.5rem;
    height: 1.5rem;
    margin-top: 0.1rem;
}
</style>

<div class="main-content">
<div class="content-wrapper">
<div class="resolve-container">
    <!-- Warning Header -->
    <div class="warning-header">
        <h1>
            <i class="fas fa-exclamation-triangle" style="margin-right: 1rem;"></i>
            Ditemukan Judul Yang Sama
        </h1>
        <p>Ditemukan judul yang sama dengan pengertian berbeda. Pilih tindakan untuk setiap istilah:</p>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert" style="font-size: 1.2rem;">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Bulk Action Controls -->
    <div class="bulk-actions">
        <h5>
            <i class="fas fa-tasks"></i> 
            <span>Pilih Tindakan Untuk Semua</span>
        </h5>
        
        <div class="row justify-content-center g-3">
            <div class="col-lg-3 col-md-6">
                <button type="button" class="btn btn-light btn-bulk w-100" 
                        id="btn-keep-existing" data-action="keep_existing" 
                        onclick="pilihSemua('keep_existing')"
                        title="Pertahankan definisi yang sudah ada di database">
                    <i class="fas fa-shield-alt"></i> 
                    <div>Gunakan Yang Sudah Ada</div>
                    <small style="font-size: 0.9rem; opacity: 0.8;">Pertahankan data lama</small>
                </button>
            </div>
            <div class="col-lg-3 col-md-6">
                <button type="button" class="btn btn-warning btn-bulk w-100" 
                        id="btn-replace-existing" data-action="replace_existing"
                        onclick="pilihSemua('replace_existing')"
                        title="Ganti dengan definisi baru dari ekstraksi">
                    <i class="fas fa-sync-alt"></i> 
                    <div>Ganti Baru</div>
                    <small style="font-size: 0.9rem; opacity: 0.8;">Update dengan data baru</small>
                </button>
            </div>
            <div class="col-lg-3 col-md-6">
                <button type="button" class="btn btn-success btn-bulk w-100" 
                        id="btn-use-both" data-action="use_both"
                        onclick="pilihSemua('use_both')"
                        title="Simpan kedua definisi dengan penomoran romawi">
                    <i class="fas fa-copy"></i> 
                    <div>Gunakan Semua (Romawi)</div>
                    <small style="font-size: 0.9rem; opacity: 0.8;">Simpan keduanya</small>
                </button>
            </div>
            <div class="col-lg-3 col-md-6">
                <button type="button" class="btn btn-outline-light btn-bulk w-100" 
                        id="btn-reset" onclick="resetSemua()"
                        title="Reset semua pilihan ke keadaan awal">
                    <i class="fas fa-eraser"></i> 
                    <div>Reset Pilihan</div>
                    <small style="font-size: 0.9rem; opacity: 0.8;">Hapus semua pilihan</small>
                </button>
            </div>
        </div>
        <div id="feedback" class="alert alert-success mt-4" style="display: none; font-size: 1.3rem; border-radius: 15px;"></div>
    </div>

    <form action="{{ route('admin.master.glosarium.process.duplicates') }}" method="POST">
        @csrf
        
        @foreach($duplicateTerms as $index => $term)
        <div class="card duplicate-card">
            <div class="card-body">
                <h2 class="card-title-large">
                    <i class="fas fa-file-alt"></i> {{ ucfirst($term['judul']) }}
                </h2>
                
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="definition-title existing">
                            <i class="fas fa-database"></i> Definisi Yang Ada
                        </h6>
                        <div class="definition-content">
                            {{ $term['existing_desc'] }}
                        </div>
                        <div class="source-info mt-2">
                            <small class="text-muted">
                                <i class="fas fa-link"></i> <strong>Judul Peraturan (sumbernya):</strong> 
                                @php
                                    $existingRecord = \App\Models\Glosarium::find($term['existing_id']);
                                @endphp
                                {{ $existingRecord->judul_perda ?? 'Tidak tersedia' }}
                            </small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h6 class="definition-title new">
                            <i class="fas fa-file-pdf"></i> Definisi Baru (dari Ekstraksi)
                        </h6>
                        <div class="definition-content">
                            {{ $term['new_desc'] }}
                        </div>
                        <div class="source-info mt-2">
                            <small class="text-muted">
                                <i class="fas fa-link"></i> <strong>Judul Peraturan (sumbernya):</strong> 
                                {{ $newPerdaData['judul_perda'] ?? 'Tidak tersedia' }}
                            </small>
                        </div>
                    </div>
                </div>
                
                <hr style="margin: 2rem 0; border-width: 2px;">
                
                <div class="mt-3">
                    <label class="action-label">
                        <i class="fas fa-hand-pointer"></i> Pilih Tindakan:
                    </label>
                    <div class="form-check">
                        <input class="form-check-input decision-radio" type="radio" name="decisions[{{ $index }}]" 
                               id="keep_existing_{{ $index }}" value="keep_existing" checked>
                        <label class="form-check-label" for="keep_existing_{{ $index }}">
                            <i class="fas fa-shield-alt text-primary"></i> <strong>Gunakan yang sudah ada</strong> - Pertahankan definisi yang ada
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input decision-radio" type="radio" name="decisions[{{ $index }}]" 
                               id="replace_existing_{{ $index }}" value="replace_existing">
                        <label class="form-check-label" for="replace_existing_{{ $index }}">
                            <i class="fas fa-sync-alt text-warning"></i> <strong>Ganti baru</strong> - Ganti dengan definisi dari ekstraksi
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input decision-radio" type="radio" name="decisions[{{ $index }}]" 
                               id="use_both_{{ $index }}" value="use_both">
                        <label class="form-check-label" for="use_both_{{ $index }}">
                            <i class="fas fa-copy text-success"></i> <strong>Gunakan semua</strong> - Simpan keduanya, yang baru diberi angka romawi ({{ ucfirst($term['judul']) }} II)
                        </label>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
        
        <div class="submit-actions">
            <button type="submit" class="btn btn-primary btn-submit">
                <i class="fas fa-check-circle"></i> Simpan
            </button>
            <a href="{{ route('admin.master.glosarium') }}" class="btn btn-secondary btn-submit">
                <i class="fas fa-times-circle"></i> Batalkan
            </a>
        </div>
    </form>
</div>
</div>
</div>

@section('script')
<script src="{{ asset('plugins/global/plugins.bundle.js') }}"></script>
<script src="{{ asset('js/scripts.bundle.js') }}"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded - Script loaded successfully');
    
    // Event listeners untuk semua tombol bulk action
    const btnKeepExisting = document.getElementById('btn-keep-existing');
    const btnReplaceExisting = document.getElementById('btn-replace-existing');
    const btnUseBoth = document.getElementById('btn-use-both');
    const btnReset = document.getElementById('btn-reset');
    
    // Fungsi pilih semua - dengan debugging
    window.pilihSemua = function(action) {
        console.log('pilihSemua dipanggil dengan action:', action);
        
        try {
            var totalChanged = 0;
            var radios = document.querySelectorAll('input[type="radio"].decision-radio');
            console.log('Ditemukan radio buttons:', radios.length);
            
            for (var i = 0; i < radios.length; i++) {
                var radio = radios[i];
                if (radio.value === action) {
                    radio.checked = true;
                    totalChanged++;
                    console.log('Radio changed:', radio.name, 'to', action);
                }
            }
            
            console.log('Total changed:', totalChanged);
            tampilkanFeedback(action, totalChanged);
            
        } catch (error) {
            console.error('Error in pilihSemua:', error);
            alert('Error: ' + error.message);
        }
    };

    window.resetSemua = function() {
        console.log('resetSemua dipanggil');
        
        try {
            var totalChanged = 0;
            var radios = document.querySelectorAll('input[type="radio"].decision-radio');
            console.log('Reset - ditemukan radio buttons:', radios.length);
            
            for (var i = 0; i < radios.length; i++) {
                var radio = radios[i];
                if (radio.value === 'keep_existing') {
                    radio.checked = true;
                    totalChanged++;
                }
            }
            
            tampilkanFeedback('reset', totalChanged);
            
        } catch (error) {
            console.error('Error in resetSemua:', error);
            alert('Error: ' + error.message);
        }
    };

    function tampilkanFeedback(action, jumlah) {
        console.log('tampilkanFeedback dipanggil:', action, jumlah);
        
        var pesan = '';
        if (action === 'keep_existing') pesan = '✅ Semua dipilih: Gunakan yang sudah ada';
        else if (action === 'replace_existing') pesan = '🔄 Semua dipilih: Ganti baru';
        else if (action === 'use_both') pesan = '📋 Semua dipilih: Gunakan semua (Romawi)';
        else if (action === 'reset') pesan = '🔄 Semua pilihan direset';
        
        var feedback = document.getElementById('feedback');
        if (feedback) {
            var jumlahIstilah = Math.floor(jumlah/3);
            feedback.innerHTML = '<i class="fas fa-check-circle"></i> ' + pesan + ' (' + jumlahIstilah + ' istilah)';
            feedback.style.display = 'block';
            feedback.classList.remove('alert-success', 'alert-warning', 'alert-info');
            feedback.classList.add('alert-success');
            
            setTimeout(function() {
                feedback.style.display = 'none';
            }, 4000);
        } else {
            console.error('Feedback element tidak ditemukan');
        }
    }

    // Add smooth scroll to form elements
    document.querySelectorAll('.form-check-input').forEach(function(radio) {
        radio.addEventListener('change', function() {
            this.closest('.form-check').style.transform = 'scale(1.02)';
            setTimeout(() => {
                this.closest('.form-check').style.transform = 'scale(1)';
            }, 200);
        });
    });
});
</script>
@endsection
@endsection
